<?php
/* --------------------------------------------------------------
   ImageProcessingConfigurationFactory.php 2023-01-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing\App\Creation;

use Gambio\Admin\Modules\ImageProcessing\Model\Configuration\CustomImageConfiguration;
use Gambio\Admin\Modules\ImageProcessing\Model\Configuration\GalleryImageConfiguration;
use Gambio\Admin\Modules\ImageProcessing\Model\Configuration\InfoImageConfiguration;
use Gambio\Admin\Modules\ImageProcessing\Model\Configuration\PopupImageConfiguration;
use Gambio\Admin\Modules\ImageProcessing\Model\Configuration\ThumbnailImageConfiguration;

/**
 * Class ImageProcessingConfigurationFactory
 *
 * @package Gambio\Admin\Modules\ImageProcessing\App\Creation
 */
class ImageProcessingConfigurationFactory
{
    /**
     * Creates a gallery image configuration object.
     *
     * @param int    $height
     * @param int    $width
     * @param string $path
     *
     * @return GalleryImageConfiguration
     */
    public function createGalleryImageConfiguration(int $height, int $width, string $path): GalleryImageConfiguration
    {
        return new GalleryImageConfiguration($height, $width, $path);
    }
    
    
    /**
     * Creates an info image configuration object.
     *
     * @param int    $height
     * @param int    $width
     * @param string $path
     *
     * @return InfoImageConfiguration
     */
    public function createInfoImageConfiguration(int $height, int $width, string $path): InfoImageConfiguration
    {
        return new InfoImageConfiguration($height, $width, $path);
    }
    
    
    /**
     * Creates a popup image configuration object.
     *
     * @param int    $height
     * @param int    $width
     * @param string $path
     *
     * @return PopupImageConfiguration
     */
    public function createPopupImageConfiguration(int $height, int $width, string $path): PopupImageConfiguration
    {
        return new PopupImageConfiguration($height, $width, $path);
    }
    
    
    /**
     * Creates a thumbnail image configuration object.
     *
     * @param int    $height
     * @param int    $width
     * @param string $path
     *
     * @return ThumbnailImageConfiguration
     */
    public function createThumbnailImageConfiguration(
        int    $height,
        int    $width,
        string $path
    ): ThumbnailImageConfiguration {
        return new ThumbnailImageConfiguration($height, $width, $path);
    }
    
    
    public function createCustomImageConfiguration(
        int    $height,
        int    $width,
        string $source,
        string $destination
    ): CustomImageConfiguration {
        return new CustomImageConfiguration($source, $destination, $width, $height);
    }
}